-- paintAnywhere 
-- by modelleicher 28.11.2021
-- allows to terraform, paint ground and foliage anywhere

-- Update 16.11.2022 - remove all collisions from Landscaping Brush so landscaping below triggers and vehicles is also possible 

-- Update 13.11.2024 - Convert to FS24  
-- Update 19.11.2024 - adjusted Multiplayer Permissions
-- Update 25.11.2024 - Fixed isse where MP Clients were restricted on their own land still (forgot to exclude PLACEMENT_BLOCKED)
-- Update 16.12.2024 - Fixed Blocked Area returning after Patch (overwriting Landscaping.isModificationAreaPlacementBlocked )


paintAndTerraformAnywhere = {};

-- remove dynamic and vehicle collisions from Landscaping Brush 
CollisionMask.LANDSCAPING = 0x00000000

-- this seems to very if access is possible for every paint and landscape operation
function paintAndTerraformAnywhere.verifyAccess(self, superFunc, a, b, c)
	local returnValue = superFunc(self, a, b, c)
	
	-- if the function returns nil (e.g. vanilla access allowed, return that)
	if returnValue == nil then
		return nil
	end
	
	-- if the current Player is Admin also allow access)
	if g_currentMission.isMasterUser then
		return nil
	end
		
	-- also make sure that given permissions are in order players are not stopped by spawn places
	if returnValue == ConstructionBrush.ERROR.STORE_PLACE or returnValue == ConstructionBrush.ERROR.SPAWN_PLACE or returnValue == ConstructionBrush.ERROR.RESTRICTED_ZONE or returnValue == ConstructionBrush.ERROR.PLACEMENT_BLOCKED then
		return nil
	end
	
	-- for all other cases return the vanilla return value
	return returnValue;
end;
ConstructionBrush.verifyAccess = Utils.overwrittenFunction(ConstructionBrush.verifyAccess, paintAndTerraformAnywhere.verifyAccess);

function paintAndTerraformAnywhere.isModificationAreaOnOwnedLand(a, superFunc, b, c, d, e, f, g)

	local ownsTargetLand = superFunc(a, b, c, d, e, f, g)
	if g_currentMission.isMasterUser or ownsTargetLand then
		return true
	end

	return false;
end;
Landscaping.isModificationAreaOnOwnedLand = Utils.overwrittenFunction(Landscaping.isModificationAreaOnOwnedLand, paintAndTerraformAnywhere.isModificationAreaOnOwnedLand);

-- not sure what this prevents as it didn't allow for terraforming through placeables
function paintAndTerraformAnywhere.hasObjectOverlapInModificationArea(...)
	return false;
end;
Landscaping.hasObjectOverlapInModificationArea = Utils.overwrittenFunction(Landscaping.hasObjectOverlapInModificationArea, paintAndTerraformAnywhere.hasObjectOverlapInModificationArea);


function paintAndTerraformAnywhere.isModificationAreaPlacementBlocked(...)

	return false;
end;
Landscaping.isModificationAreaPlacementBlocked = Utils.overwrittenFunction(Landscaping.isModificationAreaPlacementBlocked, paintAndTerraformAnywhere.isModificationAreaPlacementBlocked);


-- this allows terraforming through placeables and objects, roads and stuff (not completely anymore - update FS25)
function paintAndTerraformAnywhere.setBlockedAreaMap(...) end;
TerrainDeformation.setBlockedAreaMap = Utils.overwrittenFunction(TerrainDeformation.setBlockedAreaMap, paintAndTerraformAnywhere.setBlockedAreaMap);

-- we need this 'hack' to circumvent placement collision check which I suspect is directly in the engine function for terrain sculpting 
function paintAndTerraformAnywhere.run(self, superFunc, connection)
	
	if g_densityMapHeightManager.placementCollisionMapBackup == nil then
		g_densityMapHeightManager.placementCollisionMapBackup = g_densityMapHeightManager.placementCollisionMap
	end
	g_densityMapHeightManager.placementCollisionMap = nil
	
	superFunc(self, connection)
	
	g_densityMapHeightManager.placementCollisionMap = g_densityMapHeightManager.placementCollisionMapBackup	
end
LandscapingSculptEvent.run = Utils.overwrittenFunction(LandscapingSculptEvent.run, paintAndTerraformAnywhere.run);



