--[[
    ExtendedSpecialializationUtil

    Extends the SpecializationUtil to allow more operations on eventListeneres

	@author: 		BayernGamers
	@date: 			31.05.2025
	@version:		1.0

	History:		v1.0 @31.05.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
ExtendedSpecializationUtil = {}

function ExtendedSpecializationUtil.registerOverwrittenEventListener(vehicleType, eventName, specializationToOverride, specialization)
	if string.isNilOrWhitespace(eventName) then
		Logging.error("Given event name is is \'nil\' or empty!")
		printCallstack()
		return
	end
	local className = specialization.className
    local overrideClassName = specializationToOverride.className
	if vehicleType.eventListeners == nil then
		Logging.error("Invalid type for specialization \'%s\'!", className)
		printCallstack()
		return
	end
	if specialization[eventName] == nil then
		Logging.error("Event listener function \'%s\' not defined in specialization \'%s\'!", eventName, className)
		printCallstack()
		return
	end
    if specializationToOverride[eventName] == nil then
		Logging.error("Event listener function \'%s\' not defined in specialization \'%s\'!", eventName, overrideClassName)
		printCallstack()
		return
	end
	if vehicleType.eventListeners[eventName] == nil then
		return
	end
	local overrideSucceeded = false
	for i, existingSpecialization in pairs(vehicleType.eventListeners[eventName]) do
		if existingSpecialization == specializationToOverride then

            vehicleType.eventListeners[eventName][i] = specialization
			overrideSucceeded = true
			break
		end
	end
	if not overrideSucceeded then
        Logging.error("Event listener function \'%s\' not registered in specialization \'%s\'!", eventName, specializationToOverride)
        printCallstack()
        return
    end
end

function ExtendedSpecializationUtil.registerAppendedFunction(vehicleType, functionName, appendedFunc)
	if string.isNilOrWhitespace(functionName) then
		Logging.error("Given function name is is 'nil' or empty!")
		printCallstack()
		return
	elseif appendedFunc == nil then
		Logging.error("Given reference for AppendedFunction '%s' is 'nil'!", functionName)
		printCallstack()
	elseif vehicleType.functions[functionName] ~= nil then
		vehicleType.functions[functionName] = Utils.appendedFunction(vehicleType.functions[functionName], appendedFunc)
	end
end