--[[
    AttachableInputAttacherJointsExtension

    Adds custom xml parameters for inputAttacherJoints to attachables.

	@author: 		BayernGamers
	@date: 			05.12.2025
	@version:		1.0

	History:		v1.0 @05.12.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
                        Non-Compete:
                            This script may not be used in any scripts or mods that can be considered to be a direct competitor to the mod this script is part of.
                        Non-Compete:
                            This script may not be used in any scripts or mods that can be considered to be a direct competitor to the mod this script is part of.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "AttachableInputAttacherJointsExtension.lua")

AttachableInputAttacherJointsExtension = {}
AttachableInputAttacherJointsExtension.MOD_DIRECTORY = g_currentModDirectory
AttachableInputAttacherJointsExtension.MOD_NAME = g_currentModName

function AttachableInputAttacherJointsExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations)
end

function AttachableInputAttacherJointsExtension.initSpecialization()
    local schema = Vehicle.xmlSchema
    AttachableInputAttacherJointsExtension.registerInputAttacherJointXMLPaths(schema, Attachable.INPUT_ATTACHERJOINT_XML_KEY)
	AttachableInputAttacherJointsExtension.registerInputAttacherJointXMLPaths(schema, Attachable.INPUT_ATTACHERJOINT_CONFIG_XML_KEY)
end

function AttachableInputAttacherJointsExtension.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", AttachableInputAttacherJointsExtension)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", AttachableInputAttacherJointsExtension)
end

function AttachableInputAttacherJointsExtension.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "getAllowsAutoAttach", AttachableInputAttacherJointsExtension.getAllowsAutoAttach)
    SpecializationUtil.registerFunction(vehicleType, "getAllowsAttachFromInside", AttachableInputAttacherJointsExtension.getAllowsAttachFromInside)
end

function AttachableInputAttacherJointsExtension.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "loadInputAttacherJoint", AttachableInputAttacherJointsExtension.loadInputAttacherJoint)
end

function AttachableInputAttacherJointsExtension:onPreLoad(savegame)
    self.spec_attachableInputAttacherJointsExtension = {}
end

function AttachableInputAttacherJointsExtension:onLoad(savegame)
end

function AttachableInputAttacherJointsExtension.registerInputAttacherJointXMLPaths(schema, basePath)
    schema:register(XMLValueType.BOOL, basePath .. "#autoAttach", "Automatically attach implement if attacher joint is in distance", false)
    schema:register(XMLValueType.FLOAT, basePath .. "#autoAttachDistance", "Distance for automatic attachment", 0.1)

    schema:register(XMLValueType.BOOL, basePath .. "#allowAttachFromInside", "Allow attachment from inside the vehicle", false)
    schema:register(XMLValueType.BOOL, basePath .. "#attachHosesIfAttachedFromInside", "Attach hoses if attached from inside the vehicle", false)
    schema:register(XMLValueType.BOOL, basePath .. "#attachPTOIfAttachedFromInside", "Attach PTO if attached from inside the vehicle", false)
end

function AttachableInputAttacherJointsExtension:loadInputAttacherJoint(superFunc, xmlFile, key, inputAttacherJoint, index)
    local success = superFunc(self, xmlFile, key, inputAttacherJoint, index)

    if success then
        inputAttacherJoint.autoAttach = xmlFile:getValue(key .. "#autoAttach", false)
        inputAttacherJoint.autoAttachDistance = xmlFile:getValue(key .. "#autoAttachDistance", 0.1)

        if inputAttacherJoint.autoAttach and inputAttacherJoint.autoAttachDistance <= 0.001 then
            log:printXMLWarning(xmlFile, "Input attacher joint 'autoAttachDistance' must be greater than 0.001. Setting value to 0.001 instead.")
            inputAttacherJoint.autoAttachDistance = 0.001
        end

        inputAttacherJoint.allowAttachFromInside = xmlFile:getValue(key .. "#allowAttachFromInside", false)
        inputAttacherJoint.attachHosesIfAttachedFromInside = xmlFile:getValue(key .. "#attachHosesIfAttachedFromInside", false)
        inputAttacherJoint.attachPTOIfAttachedFromInside = xmlFile:getValue(key .. "#attachPTOIfAttachedFromInside", false)
    end

    return success
end

function AttachableInputAttacherJointsExtension:getAllowsAutoAttach(inputAttacherJointDescIndex)
    local inputAttacherJoint = self:getInputAttacherJointByJointDescIndex(inputAttacherJointDescIndex)
    if inputAttacherJoint ~= nil then
        return inputAttacherJoint.autoAttach, inputAttacherJoint.autoAttachDistance
    end

    return false
end

function AttachableInputAttacherJointsExtension:getAllowsAttachFromInside(inputAttacherJointDescIndex)
    local inputAttacherJoint = self:getInputAttacherJointByJointDescIndex(inputAttacherJointDescIndex)
    if inputAttacherJoint ~= nil then
        return inputAttacherJoint.allowAttachFromInside
    end

    return false
end