--[[
Copyright (C) GtX (Andy), 2020

Author: GtX | Andy
Date: 24.08.2020
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
]]

SetVehicleSpeedSyncEvent = {}

local SetVehicleSpeedSyncEvent_mt = Class(SetVehicleSpeedSyncEvent, Event)
InitEventClass(SetVehicleSpeedSyncEvent, "SetVehicleSpeedSyncEvent")

function SetVehicleSpeedSyncEvent.emptyNew()
    local self = Event.new(SetVehicleSpeedSyncEvent_mt)

    return self
end

function SetVehicleSpeedSyncEvent.new(vehicle, active, vehicleInRange, connectionLost)
    local self = SetVehicleSpeedSyncEvent.emptyNew()

    self.vehicle = vehicle
    self.active = Utils.getNoNil(active, false)
    self.vehicleInRange = vehicleInRange
    self.connectionLost = Utils.getNoNil(connectionLost, false)

    return self
end

function SetVehicleSpeedSyncEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.active = streamReadBool(streamId)

    if self.active then
        self.vehicleInRange = NetworkUtil.readNodeObject(streamId)
    else
        self.connectionLost = streamReadBool(streamId)
    end

    self:run(connection)
end

function SetVehicleSpeedSyncEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)

    if streamWriteBool(streamId, self.vehicleInRange ~= nil and self.active) then
        NetworkUtil.writeNodeObject(streamId, self.vehicleInRange)
    else
        streamWriteBool(streamId, self.connectionLost)
    end
end

function SetVehicleSpeedSyncEvent:run(connection)
    if self.vehicle ~= nil then
        self.vehicle:vehicleSpeedSyncSetSyncedSpeedState(self.active, self.vehicleInRange, self.connectionLost, true)
    end
end
