InGameMenuMapFrameExtension = {}

function InGameMenuMapFrameExtension.onLoadMapFinished(self, superFunc)
    if InGameMenuMapFrame.ACTIONS.SIGN_LEASE == nil or InGameMenuMapFrame.ACTIONS.TERMINATE_LEASE == nil then
        local count = 0
        for _ in pairs(InGameMenuMapFrame.ACTIONS) do
            count = count + 1
        end
        InGameMenuMapFrame.ACTIONS["SIGN_LEASE"] = count + 1
        InGameMenuMapFrame.ACTIONS["TERMINATE_LEASE"] = count + 2

        self.contextActions[InGameMenuMapFrame.ACTIONS.SIGN_LEASE] = {
            ["title"] = g_i18n:getText("button_signLease"),
            ["callback"] = InGameMenuMapFrameExtension.signLease,
            ["isActive"] = false
        }
        self.contextActions[InGameMenuMapFrame.ACTIONS.TERMINATE_LEASE] = {
            ["title"] = g_i18n:getText("button_terminateLease"),
            ["callback"] = InGameMenuMapFrameExtension.terminateLease,
            ["isActive"] = false
        }
    end

    superFunc(self)
end

InGameMenuMapFrame.onLoadMapFinished = Utils.overwrittenFunction(InGameMenuMapFrame.onLoadMapFinished, InGameMenuMapFrameExtension.onLoadMapFinished)

function InGameMenuMapFrameExtension.setMapInputContext(self, superFunc, enterVehicleActive, resetVehicleActive, sellVehicleActive, visitPlaceActive, setMarkerActive, removeMarkerActive, buyFarmlandActive, sellFarmlandActive, manageActive)
    if buyFarmlandActive then
        self.contextActions[InGameMenuMapFrame.ACTIONS.SIGN_LEASE].isActive = true
    else
        self.contextActions[InGameMenuMapFrame.ACTIONS.SIGN_LEASE].isActive = false
    end

    if sellFarmlandActive and self.selectedFarmland ~= nil then
        local selectedFarmland = self.selectedFarmland
        local leaseAgreement = g_fieldLeasingManager:getLeaseAgreement(selectedFarmland.id)
        if selectedFarmland ~= nil and leaseAgreement ~= nil then
            if leaseAgreement.duration >= g_fieldLeasingManager.minDuration then
                self.contextActions[InGameMenuMapFrame.ACTIONS.TERMINATE_LEASE].isActive = true
            end

            sellFarmlandActive = false
        else
            self.contextActions[InGameMenuMapFrame.ACTIONS.TERMINATE_LEASE].isActive = false
        end
    else
        self.contextActions[InGameMenuMapFrame.ACTIONS.TERMINATE_LEASE].isActive = false
    end

    superFunc(self, enterVehicleActive, resetVehicleActive, sellVehicleActive, visitPlaceActive, setMarkerActive, removeMarkerActive, buyFarmlandActive, sellFarmlandActive, manageActive)
end

InGameMenuMapFrame.setMapInputContext = Utils.overwrittenFunction(InGameMenuMapFrame.setMapInputContext, InGameMenuMapFrameExtension.setMapInputContext)

function InGameMenuMapFrameExtension.signLease(inGameMenuMapFrame, element)
    if inGameMenuMapFrame.selectedFarmland == nil then
        return true
    end

    local selectedFarmland = inGameMenuMapFrame.selectedFarmland

    if g_missionManager:getIsMissionRunningOnFarmland(selectedFarmland) then
        InfoDialog.show(g_i18n:getText(InGameMenuMapFrame.L10N_SYMBOL.DIALOG_BUY_FARMLAND_ACTIVE_MISSION))
        return false
    end

    local price = g_fieldLeasingManager:priceForFarmland(selectedFarmland.id)

    if inGameMenuMapFrame.playerFarm:getBalance() >= price then
        local text = string.format(g_i18n:getText("leaseFarmlandDialogText"), g_i18n:formatMoney(price, 0, true, true))
        local title = g_i18n:getText("leaseFarmlandDialogTitle")
        local callbackAction = InGameMenuMapFrameExtension.onYesNoLeaseFarmland
        YesNoDialog.show(callbackAction, inGameMenuMapFrame, text, title)
    else
        InfoDialog.show(g_i18n:getText(InGameMenuMapFrame.L10N_SYMBOL.DIALOG_BUY_FARMLAND_NOT_ENOUGH_MONEY), nil, nil, DialogElement.TYPE_WARNING)
    end

	return true
end

function InGameMenuMapFrameExtension.terminateLease(inGameMenuMapFrame, element)
    if inGameMenuMapFrame.selectedFarmland == nil then
        return true
    end

    local text = g_i18n:getText("terminateLeaseFarmlandDialogText")
    local title = g_i18n:getText("terminateLeaseFarmlandDialogTitle")
    local callbackAction = InGameMenuMapFrameExtension.onYesNoTerminateLeaseFarmland
    YesNoDialog.show(callbackAction, inGameMenuMapFrame, text, title)

	return true
end

function InGameMenuMapFrameExtension.onYesNoLeaseFarmland(inGameMenuMapFrame, accepted)
    if accepted then
        local selectedFarmland = inGameMenuMapFrame.selectedFarmland
        g_client:getServerConnection():sendEvent(LeaseFarmlandEvent.new(true, selectedFarmland.id, g_currentMission:getFarmId(), selectedFarmland.price))
        inGameMenuMapFrame:setMapSelectionItem()
        InGameMenuMapUtil.hideContextBox(inGameMenuMapFrame.contextBox)
        InGameMenuMapUtil.hideContextBox(inGameMenuMapFrame.contextBoxPlayer)
        InGameMenuMapUtil.hideContextBox(inGameMenuMapFrame.contextBoxFarmland)
    else
		inGameMenuMapFrame.elementToFocus = inGameMenuMapFrame.contextButtonListFarmland
    end
end

function InGameMenuMapFrameExtension.onYesNoTerminateLeaseFarmland(inGameMenuMapFrame, accepted)
    if accepted then
        local selectedFarmland = inGameMenuMapFrame.selectedFarmland
        g_client:getServerConnection():sendEvent(LeaseFarmlandEvent.new(false, selectedFarmland.id, FarmlandManager.NO_OWNER_FARM_ID, selectedFarmland.price))
        inGameMenuMapFrame:setMapSelectionItem()
        InGameMenuMapUtil.hideContextBox(inGameMenuMapFrame.contextBox)
        InGameMenuMapUtil.hideContextBox(inGameMenuMapFrame.contextBoxPlayer)
        InGameMenuMapUtil.hideContextBox(inGameMenuMapFrame.contextBoxFarmland)
    else
		inGameMenuMapFrame.elementToFocus = inGameMenuMapFrame.contextButtonListFarmland
    end
end