-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles
myself, the author, to unlimited free and unrestricted use,
access, and distribution of any works related to the unauthorized
user and/or distributor.

--]]

local THPHMap = {}
local THPHMap_mt = Class(THPHMap)
THPHMap.DATA_KEY = tostring(THPHMap)
local debugFlagId = THPFConfig.DEBUG_FLAG_ID.PHMap
THPHMap.debugFlagId = debugFlagId
local function getCustomData(parent)
    return THUtils.getDataTable(parent, THPHMap.DATA_KEY)
end
THPHMap.getCustomData = getCustomData
THSprayTypes.PHMap = THPHMap
local function initScript()
    local pfData = g_thPFConfig.precisionFarming
    if pfData.isFound then
        local pfModEnv = pfData.mod.environment
        local PHMap = pfModEnv.PHMap
        THUtils.setFunctionHook(PHMap, "loadFromXML", false, false, nil, THPHMap.gInj_loadFromXML)
    end
end
function THPHMap.new(parent, customMt)
    customMt = customMt or THPHMap_mt
    if THUtils.argIsValid(type(parent) == THValueType.TABLE, "parent", parent)
        and THUtils.argIsValid(type(customMt) == THValueType.TABLE, "customMt", customMt)
    then
        local self = getCustomData(parent)
        if self == nil then
            self = THUtils.createDataTable(parent, THPHMap.DATA_KEY, customMt)
            if self ~= nil then
                THUtils.setFunctionHook(parent, "getLimeUsageByStateChange", false, false, self, THPHMap.inj_getLimeUsageByStateChange)
            end
        end
        return self
    end
end
function THPHMap.setUsageSprayType(self, sprayType)
    local lastUsageSprayType = self.usageSprayType
    if sprayType == nil then
        self.usageSprayType = nil
    else
        local xtSprayTypeData = g_thSprayTypes:getExtendedSprayType(sprayType)
        if xtSprayTypeData ~= nil
            and xtSprayTypeData.groupIndex == THSprayTypes.SPRAY_TYPE_GROUP.LIME
        then
            self.usageSprayType = xtSprayTypeData.sprayType.index
        end
    end
    return lastUsageSprayType
end
function THPHMap.inj_getLimeUsageByStateChange(self, superFunc, parent, ...)
    local function appendFunc(rUsage, ...)
        if type(rUsage) == THValueType.NUMBER and rUsage > 0 then
            THUtils.pcall(function()
                if self.parent == parent and self.usageSprayType ~= nil then
                    local xtSprayTypeData = g_thSprayTypes:getExtendedSprayType(self.usageSprayType)
                    if xtSprayTypeData ~= nil then
                        rUsage = rUsage * (xtSprayTypeData.usageFactor or 1)
                        if THUtils.getIsDebugEnabled(debugFlagId, THDebugLevel.UPDATE) then
                            THUtils.displayMsg("THPHMap: Lime usage information:")
                            THUtils.displayMsg("- usage fill type: %s", xtSprayTypeData.fillType.name)
                            if xtSprayTypeData.usageFactor ~= nil then
                                THUtils.displayMsg("- usage factor: %s", xtSprayTypeData.usageFactor)
                            end
                        end
                    end
                end
            end)
        end
        return rUsage, ...
    end
    return appendFunc(superFunc(parent, ...))
end
function THPHMap.gInj_loadFromXML(superFunc, parent, xmlFile, xmlKey, ...)
    local pfData = g_thPFConfig.precisionFarming
    if pfData.isFound then
        THUtils.pcall(function()
            local self = getCustomData(parent)
            if self == nil then
                self = THPHMap.new(parent)
            end
        end)
    end
    return superFunc(parent, xmlFile, xmlKey, ...)
end
THUtils.pcall(initScript)