-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

--[[

Unauthorized use and/or distribution of this work entitles
myself, the author, to unlimited free and unrestricted use,
access, and distribution of any works related to the unauthorized
user and/or distributor.

--]]

local THExtendedSprayerHUDExtension = {}
local THExtendedSprayerHUDExtension_mt = Class(THExtendedSprayerHUDExtension)
THExtendedSprayerHUDExtension.DATA_KEY = tostring(THExtendedSprayerHUDExtension)
THExtendedSprayerHUDExtension.TEXT_KEYS = {
    "headline_ph_lime",
    "headline_n_solidFertilizer",
    "headline_n_liquidFertilizer",
    "headline_n_slurryTanker",
    "headline_n_manureSpreader"
}
local debugFlagId = THSprayTypes.debugFlagId
local function getCustomData(parent)
    return THUtils.getDataTable(parent, THExtendedSprayerHUDExtension.DATA_KEY)
end
THExtendedSprayerHUDExtension.getCustomData = getCustomData
THSprayTypes.ExtendedSprayerHUDExtension = THExtendedSprayerHUDExtension
local function initScript()
    local pfData = g_thPFConfig.precisionFarming
    if pfData.isFound then
        local ExtendedSprayerHUDExtension = pfData.mod.environment.ExtendedSprayerHUDExtension
        THUtils.setFunctionHook(ExtendedSprayerHUDExtension, "new", false, false, nil, THExtendedSprayerHUDExtension.gInj_new)
        THUtils.setFunctionHook(ExtendedSprayerHUDExtension, "draw", false, false, nil, THExtendedSprayerHUDExtension.gInj_draw)
    end
end
function THExtendedSprayerHUDExtension.new(parent, customMt)
    customMt = customMt or THExtendedSprayerHUDExtension_mt
    if THUtils.argIsValid(type(parent) == THValueType.TABLE, "parent", parent)
        and THUtils.argIsValid(type(customMt) == THValueType.TABLE, "customMt", customMt)
    then
        local self = getCustomData(parent)
        if self == nil then
            self = THUtils.createDataTable(parent, THExtendedSprayerHUDExtension.DATA_KEY, customMt)
            if self ~= nil then
                self.defaultTexts = {}
                for key, value in pairs(parent.texts) do
                    self.defaultTexts[key] = value
                end
                self.texts = {}
                for _, textKey in pairs(THExtendedSprayerHUDExtension.TEXT_KEYS) do
                    local absTextKey = "thHudExtensionSprayer_" .. textKey
                    if g_i18n:hasText(absTextKey) then
                        self.texts[textKey] = g_i18n:getText(absTextKey)
                    end
                end
            end
        end
        return self
    end
end
function THExtendedSprayerHUDExtension.gInj_new(superFunc, ...)
    local function appendFunc(rParent, ...)
        if rParent ~= nil then
            THUtils.pcall(function()
                local self = THExtendedSprayerHUDExtension.new(rParent)
            end)
        end
        return rParent, ...
    end
    return appendFunc(superFunc(...))
end
function THExtendedSprayerHUDExtension.gInj_draw(superFunc, parent, ...)
    local self = getCustomData(parent)
    local pfData = g_thPFConfig.precisionFarming
    local lastPHMapUsageSprayType, isPHMapUsageSet = nil, false
    if self ~= nil
        and pfData ~= nil and pfData.isFound
    then
        THUtils.pcall(function()
            local ExtendedSprayer = pfData.mod.environment.ExtendedSprayer
            local extendedSprayerSpec = parent.extendedSprayer
            local vehicle = parent.vehicle
            if ExtendedSprayer ~= nil and vehicle ~= nil
                and extendedSprayerSpec ~= nil
            then
                local thXTSpraySpec = THVSpec_XTSprayTypes.getSpecTable(vehicle)
                if thXTSpraySpec ~= nil then
                    local sourceFillType, sourceFillUnitIndex, sourceVehicle = THVSpec_XTSprayTypes.getSprayerFillType(vehicle)
                    if sourceFillType ~= nil and sourceFillType ~= FillType.UNKNOWN
                        and sourceFillUnitIndex ~= nil
                        and sourceVehicle ~= nil
                    then
                        local xtSprayTypeData = g_thSprayTypes:getExtendedSprayTypeByFillType(sourceFillType)
                        if xtSprayTypeData ~= nil then
                            THVSpec_XTSprayTypes.setCurrentSprayerType(vehicle, xtSprayTypeData.fillType.index)
                            local isSprayTypeMapped, isFillTypeMapped = xtSprayTypeData:activateMapping()
                            if THUtils.getIsDebugEnabled(debugFlagId, THDebugLevel.UPDATE) then
                                if isSprayTypeMapped then
                                    THUtils.displayMsg("THExtendedSprayerHUDExtension (draw): Spray type %q mapped to %q", xtSprayTypeData.baseSprayType.name, xtSprayTypeData.sprayType.name)
                                end
                                if isFillTypeMapped then
                                    THUtils.displayMsg("THExtendedSprayerHUDExtension (draw): Spray fill type %q mapped to %q", xtSprayTypeData.baseFillType.name, xtSprayTypeData.fillType.name)
                                end
                                if isSprayTypeMapped or isFillTypeMapped then
                                    THUtils.displayMsg("")
                                end
                            end
                            local headlineTextKey = nil
                            if xtSprayTypeData.groupIndex == THSprayTypes.SPRAY_TYPE_GROUP.FERTILIZER then
                                if xtSprayTypeData.subTypeIndex == THSprayTypes.SPRAY_SUB_TYPE.LIQUID then
                                    headlineTextKey = "headline_n_liquidFertilizer"
                                else
                                    headlineTextKey = "headline_n_solidFertilizer"
                                end
                            elseif xtSprayTypeData.groupIndex == THSprayTypes.SPRAY_TYPE_GROUP.MANURE
                                or xtSprayTypeData.groupIndex == THSprayTypes.SPRAY_TYPE_GROUP.DIGESTATE
                            then
                                if xtSprayTypeData.subTypeIndex == THSprayTypes.SPRAY_SUB_TYPE.LIQUID then
                                    headlineTextKey = "headline_n_slurryTanker"
                                else
                                    headlineTextKey = "headline_n_manureSpreader"
                                end
                            elseif xtSprayTypeData.groupIndex == THSprayTypes.SPRAY_TYPE_GROUP.LIME then
                                headlineTextKey = "headline_ph_lime"
                            end
                            if headlineTextKey ~= nil and self.texts[headlineTextKey] ~= nil then
                                local headlineText = string.format(self.texts[headlineTextKey], xtSprayTypeData.fillType.title)
                                parent.texts[headlineTextKey] = headlineText
                            end
                            if xtSprayTypeData.groupIndex == THSprayTypes.SPRAY_TYPE_GROUP.LIME then
                                local thPHMapData = THSprayTypes.PHMap.getCustomData(parent.pHMap)
                                if thPHMapData ~= nil then
                                    lastPHMapUsageSprayType = thPHMapData:setUsageSprayType(xtSprayTypeData.sprayType.index)
                                    isPHMapUsageSet = true
                                end
                            end
                        end
                    end
                end
            end
        end)
    end
    local function appendFunc(...)
        if self ~= nil
            and pfData ~= nil and pfData.isFound
        then
            THUtils.pcall(function()
                g_thSprayTypes:resetExtendedSprayTypeConstants()
                local vehicle = parent.vehicle
                if vehicle ~= nil then
                    local thSprayerSpec = THVSpec_XTSprayTypes.getSpecTable(vehicle)
                    if thSprayerSpec ~= nil then
                        THVSpec_XTSprayTypes.resetSprayerTypes(vehicle)
                    end
                end
                for textKey in pairs(self.texts) do
                    local defaultText = self.defaultTexts[textKey]
                    if defaultText ~= nil then
                        parent.texts[textKey] = defaultText
                    end
                end
                if isPHMapUsageSet then
                    local thPHMapData = THSprayTypes.PHMap.getCustomData(parent.pHMap)
                    if thPHMapData ~= nil then
                        thPHMapData:setUsageSprayType(lastPHMapUsageSprayType)
                    end
                end
            end)
        end
        return ...
    end
    return appendFunc(superFunc(parent, ...))
end
THUtils.pcall(initScript)